/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.loomchild.segment.srx.Rule;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.util.Util;

public class RuleMatcher {
    private SrxDocument document;
    private Rule rule;
    private CharSequence text;
    private Matcher beforeMatcher;
    private Matcher afterMatcher;
    boolean found;

    public RuleMatcher(SrxDocument document, Rule rule, CharSequence text) {
        this.document = document;
        this.rule = rule;
        this.text = text;
        Pattern beforePattern = Util.compile(document, rule.getBeforePattern());
        Pattern afterPattern = Util.compile(document, rule.getAfterPattern());
        this.beforeMatcher = beforePattern.matcher(text);
        this.afterMatcher = afterPattern.matcher(text);
        this.found = true;
    }

    public boolean find() {
        this.found = false;
        while (!this.found && this.beforeMatcher.find()) {
            this.afterMatcher.region(this.beforeMatcher.end(), this.text.length());
            this.found = this.afterMatcher.lookingAt();
        }
        return this.found;
    }

    public boolean find(int start2) {
        this.beforeMatcher.region(start2, this.text.length());
        return this.find();
    }

    public boolean hitEnd() {
        return !this.found;
    }

    public int getStartPosition() {
        return this.beforeMatcher.start();
    }

    public int getBreakPosition() {
        return this.afterMatcher.start();
    }

    public int getEndPosition() {
        return this.afterMatcher.end();
    }

    public Rule getRule() {
        return this.rule;
    }
}

